/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime;

import filenet.vw.api.VWDataField;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWParticipantHistory;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkTestDataField;
import filenet.vw.toolkit.runtime.VWTrkWorkObject;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Date;

public class VWTrkParticipantHistory {
    VWTrkParticipant m_participant = null;
    private VWParticipantHistory m_participantHistory = null;
    private String m_wobNumber = null;
    private VWParticipant m_vwParticipant = null;
    private VWParticipant m_user = null;
    private String m_queueName = null;
    private String m_operationName = null;
    private Date m_completionDate = null;
    private Date m_dateReceived = null;
    private String m_response = null;
    private String m_comments = null;
    private VWTrkTestDataField[] m_dataFields = null;

    public VWTrkParticipantHistory(VWTrkParticipant participant, VWParticipantHistory history) {
        this.m_participant = participant;
        this.m_participantHistory = history;
    }

    public VWTrkParticipantHistory(VWTrkParticipant participant, VWTrkWorkObject vwWorkObject) throws VWException {
        this.m_participant = participant;
        this.updateParticipantHistroy(vwWorkObject);
    }

    public void updateParticipantHistroy(VWTrkWorkObject vwWorkObject) throws VWException {
        if (vwWorkObject == null) {
            return;
        }
        this.m_completionDate = null;
        try {
            if (this.m_dateReceived == null) {
                this.m_dateReceived = vwWorkObject.getDateReceived();
            }
            this.m_vwParticipant = vwWorkObject.getParticipant();
            this.m_response = vwWorkObject.getSelectedResponse();
            this.m_comments = vwWorkObject.getComment();
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            throw ex;
        }
    }

    public void updateParticipantHistroy(VWParticipantHistory vwParticipantHistory) {
        this.m_participantHistory = vwParticipantHistory;
    }

    private VWFieldDefinition getFieldDefinition(String name) {
        if (this.m_participant != null) {
            return this.m_participant.getFieldDefinition(name);
        }
        return null;
    }

    public Date getCompletionDate() {
        if (this.m_participantHistory != null) {
            return this.m_participantHistory.getCompletionDate();
        }
        return this.m_completionDate;
    }

    public Date getDateReceived() {
        if (this.m_participantHistory != null && this.m_dateReceived == null) {
            this.m_dateReceived = this.m_participantHistory.getDateReceived();
        }
        return this.m_dateReceived;
    }

    public VWParticipantHistory getVWParticipantHistory() {
        return this.m_participantHistory;
    }

    public int getStatus() {
        int status = -1;
        if (this.m_participantHistory != null) {
            try {
                status = this.m_participantHistory.getStepStatus();
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        }
        return status;
    }

    public VWParticipant getParticipant() {
        if (this.m_participantHistory != null) {
            try {
                if (this.m_vwParticipant == null) {
                    this.m_vwParticipant = this.m_participantHistory.getParticipantNamePx();
                    if (this.m_vwParticipant != null && VWStringUtils.compare(this.m_vwParticipant.getParticipantName(), "(NONE)") == 0) {
                        this.m_vwParticipant = null;
                    }
                }
            }
            catch (VWException ex) {
                return new VWParticipant("");
            }
        }
        return this.m_vwParticipant;
    }

    public VWParticipant getUser() {
        if (this.m_participantHistory != null) {
            try {
                if (this.m_user == null) {
                    this.m_user = this.m_participantHistory.getUserNamePx();
                    if (this.m_user != null && VWStringUtils.compare(this.m_user.getParticipantName(), "(NONE)") == 0) {
                        this.m_user = null;
                    }
                }
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        }
        return this.m_user;
    }

    public String getQueueName() {
        if (this.m_participantHistory != null) {
            try {
                if (this.m_queueName == null) {
                    this.m_queueName = this.m_participantHistory.getQueueName();
                }
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        }
        return this.m_queueName;
    }

    public String getOperationName() {
        if (this.m_participantHistory != null) {
            try {
                if (this.m_operationName == null) {
                    this.m_operationName = this.m_participantHistory.getOperationName();
                }
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        }
        return this.m_operationName;
    }

    public String getResponse() {
        try {
            if (this.m_participant != null && this.m_participant.isActive()) {
                return this.m_participant.getResponse();
            }
            if (this.m_participantHistory != null) {
                return this.m_participantHistory.getResponse();
            }
            return this.m_response;
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public String getComments() {
        try {
            if (this.m_participant != null && this.m_participant.isActive()) {
                return this.m_participant.getComments();
            }
            if (this.m_participantHistory != null) {
                return this.m_participantHistory.getComments();
            }
            return this.m_comments;
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public VWTrkTestDataField[] getLogFields() {
        if (this.m_dataFields == null && this.m_participantHistory != null) {
            try {
                VWDataField[] dataFields = this.m_participantHistory.getLogFields();
                if (dataFields != null && dataFields.length > 0) {
                    int length = dataFields.length;
                    this.m_dataFields = new VWTrkTestDataField[length];
                    for (int i = 0; i < length; ++i) {
                        this.m_dataFields[i] = new VWTrkTestDataField(dataFields[i], this.getFieldDefinition(dataFields[i].getName()));
                    }
                } else {
                    this.m_dataFields = null;
                }
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
                return null;
            }
        }
        return this.m_dataFields;
    }

    public String getWorkObjectNumber() {
        if (this.m_participantHistory != null) {
            return this.m_participantHistory.getWorkObjectNumber();
        }
        return this.m_wobNumber;
    }

    public boolean isOverdue() {
        if (this.m_participantHistory != null) {
            return this.m_participantHistory.getIsOverdue();
        }
        return false;
    }

    public boolean isReminded() {
        if (this.m_participantHistory != null) {
            return this.m_participantHistory.getIsReminded();
        }
        return false;
    }

    public Date getOverdue() {
        try {
            if (this.m_participantHistory != null) {
                return this.m_participantHistory.getOverdue();
            }
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return null;
    }

    public Date getReminder() {
        try {
            if (this.m_participantHistory != null) {
                return this.m_participantHistory.getReminder();
            }
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return null;
    }

    public void removeReferences() {
        this.m_participant = null;
        this.m_participantHistory = null;
        this.m_wobNumber = null;
        this.m_vwParticipant = null;
        this.m_user = null;
        this.m_queueName = null;
        this.m_completionDate = null;
        this.m_dateReceived = null;
        this.m_response = null;
        this.m_comments = null;
        if (this.m_dataFields != null) {
            for (int i = this.m_dataFields.length - 1; i >= 0; --i) {
                this.m_dataFields[i].removeReferences();
                this.m_dataFields[i] = null;
            }
            this.m_dataFields = null;
        }
    }
}

